<!DOCTYPE html>
<html <?php language_attributes(); ?>>
	<head>
		<meta charset="<?php bloginfo('charset'); ?>">
		<link rel="preconnect" href="https://fonts.googleapis.com">
		<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
<?php /* wp_head(); */ ?>
		<title><?php echo $GLOBALS["__title"]; ?></title> 
		<meta name="description" content="<?php echo $GLOBALS["__description"]; ?>">
		<meta name="keywords" content="<?php echo $GLOBALS["__keywords"]; ?>">
		<link rel="canonical" href="<?php echo $GLOBALS["__canonical"]; ?>">
		<link rel="icon" type="image/png" sizes="32x32" href="data:image/png;base64, RnJ1aXR0eQ==">
		<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
		<link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/pico/pico.min.css">
		<link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/bootstrap/bootstrap-grid.min.css">
		<link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/lineicons/lineicons.min.css">
		<link href="https://fonts.googleapis.com/css2?family=Indie+Flower&display=swap" rel="stylesheet">
		<link href="https://fonts.googleapis.com/css2?family=Londrina+Shadow&display=swap" rel="stylesheet">		
		<link rel="stylesheet" href="<?php echo get_stylesheet_uri(); ?>?version=<?php echo rand(10,1000); ?>">
		<link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/css/demo.css">
	</head>
	<body <?php body_class(); ?>>
		<header class="container pt-5">
			<hgroup>
				<h1><a href="/"><?php bloginfo('name'); ?></a></h1>
				<p><?php bloginfo('description'); ?></p>
			</hgroup>
			<nav>
				<ul>
					<li>
						<details class="dropdown">
							<summary role="button" class="secondary">Navigation</summary>
							<ul>
								<li><a href="<?php echo get_site_url(); ?>">Home</a></li>
								<li><a href="<?php echo get_site_url(); ?>/bootstrap/">Bootstrap Grid</a></li>
								<li><a href="<?php echo get_site_url(); ?>/lineicons/">Lineicons</a></li>
								<li><a href="<?php echo get_site_url(); ?>/pico/">Pico</a></li>
								<li><a href="<?php echo get_site_url(); ?>/blank-page/">Page Example</a></li>
								<li><a href="<?php echo get_site_url(); ?>/blank-post/">Post Example</a></li>
								<li><a href="<?php echo get_site_url(); ?>/category/topic/">Category Example</a></li>
								<li><a href="<?php echo get_site_url(); ?>/tag/tag1/">Tag Example</a></li>
							</ul>
						</details>
					</li>
				</ul>
				<ul>
					<li><a href="#" data-theme-switcher="auto">Auto</a></li>
					<li><a href="#" data-theme-switcher="light">Light</a></li>
					<li><a href="#" data-theme-switcher="dark">Dark</a></li>
				</ul>
			</nav>
    	</header>