<?php /* Template Name: Front page */ ?>
<?php 
$__title 		= "Fruitty.co.uk - HTML 1st WordPress theme";
$__description 	= "Bootstrap Grid, Pico minimalist starter kit and Lineicons together in one WordPress theme.";
$__keywords 	= "fruitty, bootstrap, pico, lineicons"; 
$__canonical 	= get_permalink(); 
?>
<?php get_header(); ?>

		<main class="container">
			<article>
				<p><b>HTML 1st WordPress theme</b> for WordPress developers to build from.. <a href="#">download version one</a></p>
				<div class="lucky mb-5">
					<i class="lni lni-diamonds-1 white"></i>
					<i class="lni lni-crown-3 gold"></i>
					<i class="lni lni-heart red"></i>
					<i class="lni lni-diamonds-1 white"></i>
				</div>
				<p>Bootstrap Grid, Pico minimalist starter kit and Lineicons together in one WordPress theme.</p>
				<div class="lib-brands mb-5">
					<img src="https://upload.wikimedia.org/wikipedia/commons/thumb/b/b2/Bootstrap_logo.svg/1024px-Bootstrap_logo.svg.png?20210507000024" class="lib-logo">
					<svg class="max-xs:w-[120px] h-8 w-[165px]" viewBox="0 0 133 26" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M37.2409 21.2563C37.2409 22.0128 37.8541 22.626 38.6105 22.626C39.367 22.626 39.9802 22.0128 39.9802 21.2563V7.00203C39.9802 6.24561 39.367 5.6324 38.6105 5.6324C37.8541 5.6324 37.2409 6.24561 37.2409 7.00203V21.2563Z" fill="#343C54"></path><path d="M45.2524 21.2563C45.2524 22.0128 44.6392 22.626 43.8828 22.626C43.1263 22.626 42.5131 22.0128 42.5131 21.2563V11.3138C42.5131 10.5574 43.1263 9.9442 43.8828 9.9442C44.6392 9.9442 45.2524 10.5574 45.2524 11.3138V21.2563Z" fill="#343C54"></path><path d="M75.4808 21.2563C75.4808 22.0128 76.094 22.626 76.8504 22.626C77.6068 22.626 78.22 22.0128 78.22 21.2563V11.3138C78.22 10.5574 77.6068 9.9442 76.8504 9.9442C76.094 9.9442 75.4808 10.5574 75.4808 11.3138V21.2563Z" fill="#343C54"></path><path d="M86.2676 22.9049C84.9487 22.9049 83.8327 22.6259 82.9196 22.0679C82.0065 21.5099 81.3048 20.7406 80.8144 19.7599C80.341 18.7791 80.1043 17.6378 80.1043 16.3358C80.1043 15.0338 80.3494 13.8924 80.8398 12.9117C81.3471 11.9141 82.0657 11.1447 82.9957 10.6036C83.9257 10.0456 85.0501 9.76663 86.369 9.76663C87.485 9.76663 88.4658 9.97799 89.3112 10.4007C90.1567 10.8234 90.8077 11.4153 91.2642 12.1762C91.5656 12.6605 91.7504 13.1793 91.8556 13.718C91.9994 14.4535 91.3669 15.0676 90.6174 15.0676C89.868 15.0676 89.3255 14.436 89.0731 13.7303C88.9587 13.4104 88.7787 13.119 88.4996 12.8863C88.0092 12.4467 87.2399 12.2269 86.1915 12.2269C84.974 12.2269 84.1032 12.5735 83.5791 13.2668C83.0718 13.9432 82.8181 14.9577 82.8181 16.3104C82.8181 17.6801 83.0718 18.7115 83.5791 19.4048C84.1032 20.0811 84.974 20.4193 86.1915 20.4193C87.2399 20.4193 88.0092 20.208 88.4996 19.7852C88.7731 19.5482 88.9522 19.2577 89.0675 18.9402C89.3233 18.2358 89.868 17.604 90.6174 17.604C91.3669 17.604 91.9986 18.2185 91.8489 18.9528C91.7412 19.4813 91.5562 19.9904 91.2642 20.47C90.7908 21.2309 90.1228 21.8312 89.2605 22.2709C88.415 22.6936 87.4174 22.9049 86.2676 22.9049Z" fill="#343C54"></path><path fill-rule="evenodd" clip-rule="evenodd" d="M96.5951 22.0679C97.542 22.609 98.658 22.8796 99.9431 22.8796C101.228 22.8796 102.327 22.609 103.24 22.0679C104.17 21.5099 104.881 20.7406 105.371 19.7599C105.878 18.7622 106.132 17.6124 106.132 16.3104C106.132 15.0084 105.878 13.8671 105.371 12.8863C104.881 11.9056 104.17 11.1447 103.24 10.6036C102.327 10.0456 101.228 9.76663 99.9431 9.76663C98.658 9.76663 97.542 10.0456 96.5951 10.6036C95.6482 11.1447 94.9211 11.9056 94.4138 12.8863C93.9066 13.8671 93.6529 15.0084 93.6529 16.3104C93.6529 17.6124 93.9066 18.7622 94.4138 19.7599C94.9211 20.7406 95.6482 21.5099 96.5951 22.0679ZM102.708 19.4555C102.184 20.115 101.262 20.4447 99.9431 20.4447C98.6073 20.4447 97.6773 20.115 97.1531 19.4555C96.6289 18.7791 96.3668 17.7308 96.3668 16.3104C96.3668 14.8901 96.6289 13.8502 97.1531 13.1907C97.6773 12.5313 98.6073 12.2015 99.9431 12.2015C101.262 12.2015 102.184 12.5313 102.708 13.1907C103.232 13.8502 103.494 14.8901 103.494 16.3104C103.494 17.7308 103.232 18.7791 102.708 19.4555Z" fill="#343C54"></path><path d="M119.923 21.2563C119.923 22.0127 119.31 22.6259 118.553 22.6259C117.797 22.6259 117.184 22.0127 117.184 21.2563V15.2959C117.184 14.1799 116.972 13.3767 116.549 12.8863C116.127 12.3791 115.332 12.1254 114.165 12.1254C113.421 12.1254 112.813 12.2353 112.339 12.4552C111.866 12.6581 111.511 12.9963 111.274 13.4697C111.037 13.9263 110.919 14.5519 110.919 15.3466V21.2563C110.919 22.0127 110.306 22.6259 109.549 22.6259C108.793 22.6259 108.18 22.0127 108.18 21.2563V11.2758C108.18 10.5824 108.742 10.0203 109.435 10.0203C110.128 10.0203 110.691 10.5824 110.691 11.2758V12.3791H110.817C111.003 11.9225 111.282 11.4998 111.654 11.1109C112.026 10.722 112.5 10.4007 113.075 10.1471C113.667 9.89345 114.368 9.76663 115.18 9.76663C116.279 9.76663 117.175 9.97799 117.868 10.4007C118.562 10.8234 119.077 11.4068 119.416 12.1508C119.754 12.8948 119.923 13.7487 119.923 14.7125V21.2563Z" fill="#343C54"></path><path d="M127.772 22.8796C125.929 22.8796 124.534 22.516 123.587 21.7889C122.878 21.2319 122.485 20.4612 122.301 19.6237C122.144 18.9124 122.757 18.3141 123.486 18.3141C124.214 18.3141 124.687 18.9361 124.943 19.618C124.974 19.701 125.012 19.7822 125.058 19.8613C125.244 20.1319 125.549 20.3348 125.971 20.47C126.411 20.5884 127.028 20.6476 127.823 20.6476C128.499 20.6476 129.007 20.5969 129.345 20.4954C129.7 20.377 129.937 20.2164 130.055 20.0135C130.173 19.8106 130.233 19.557 130.233 19.2526C130.233 18.7453 130.055 18.3902 129.7 18.1873C129.345 17.9675 128.711 17.7731 127.798 17.604L125.819 17.2742C125.075 17.1221 124.424 16.9107 123.866 16.6402C123.325 16.3527 122.902 15.9638 122.598 15.4734C122.311 14.9662 122.167 14.3321 122.167 13.5712C122.167 12.4383 122.615 11.5252 123.511 10.8319C124.407 10.1217 125.676 9.76663 127.316 9.76663C128.313 9.76663 129.201 9.92727 129.979 10.2485C130.757 10.5698 131.374 11.0517 131.83 11.6943C132.123 12.1065 132.298 12.5598 132.398 13.0335C132.546 13.7395 131.93 14.3321 131.209 14.3321C130.488 14.3321 130.009 13.7113 129.727 13.0473C129.718 13.0274 129.709 13.0076 129.7 12.9878C129.565 12.6834 129.311 12.4467 128.939 12.2776C128.567 12.1085 128.001 12.024 127.24 12.024C126.242 12.024 125.583 12.1508 125.261 12.4044C124.94 12.6581 124.779 13.0301 124.779 13.5204C124.779 14.0108 124.923 14.3574 125.211 14.5603C125.515 14.7463 126.107 14.9323 126.986 15.1183L129.142 15.5242C129.954 15.6763 130.63 15.9046 131.171 16.209C131.712 16.5133 132.118 16.9107 132.388 17.4011C132.676 17.8914 132.82 18.4748 132.82 19.1511C132.82 20.3348 132.372 21.2563 131.475 21.9158C130.596 22.5583 129.362 22.8796 127.772 22.8796Z" fill="#343C54"></path><path fill-rule="evenodd" clip-rule="evenodd" d="M67.6896 22.8796C66.32 22.8796 65.1786 22.609 64.2655 22.0679C63.3524 21.5099 62.6761 20.7406 62.2364 19.7599C61.7968 18.7622 61.577 17.6124 61.577 16.3104C61.577 15.0084 61.8222 13.8671 62.3125 12.8863C62.8198 11.9056 63.53 11.1447 64.4431 10.6036C65.3561 10.0456 66.4383 9.76663 67.6896 9.76663C68.8225 9.76663 69.8201 9.98645 70.6825 10.4261C71.5618 10.8488 72.2381 11.466 72.7116 12.2776C73.2019 13.0893 73.4471 14.07 73.4471 15.2198C73.4471 15.4448 73.4423 15.6732 73.4309 15.9019C73.3999 16.521 72.8659 16.9699 72.246 16.9699H64.1469C64.1747 17.6419 64.2734 18.2252 64.4431 18.72C64.6629 19.2949 65.0349 19.726 65.5591 20.0135C66.0832 20.301 66.8019 20.4447 67.715 20.4447C68.7802 20.4447 69.5327 20.2756 69.9723 19.9374C70.0818 19.8532 70.1747 19.7621 70.253 19.665C70.7235 19.0816 71.2393 18.3902 71.9887 18.3902C72.7381 18.3902 73.3815 19.0106 73.1833 19.7333C73.0728 20.1359 72.8981 20.5195 72.6355 20.8759C72.162 21.5015 71.5026 21.9919 70.6571 22.3469C69.8286 22.702 68.8394 22.8796 67.6896 22.8796ZM64.8742 13.0639C64.4804 13.5935 64.2447 14.2868 64.1672 15.1437H70.8262C70.8563 14.4806 70.7661 13.931 70.5557 13.4951C70.3359 13.0047 69.9723 12.6412 69.465 12.4044C68.9747 12.1677 68.3575 12.0494 67.6135 12.0494C66.2777 12.0494 65.3646 12.3875 64.8742 13.0639Z" fill="#343C54"></path><path d="M56.7718 21.2563C56.7718 22.0127 57.385 22.6259 58.1414 22.6259C58.8979 22.6259 59.5111 22.0127 59.5111 21.2563V14.7125C59.5111 13.7487 59.342 12.8948 59.0038 12.1508C58.6656 11.4068 58.1499 10.8234 57.4566 10.4007C56.7634 9.97799 55.8672 9.76663 54.7681 9.76663C53.9565 9.76663 53.2547 9.89345 52.6629 10.1471C52.088 10.4007 51.6146 10.722 51.2426 11.1109C50.8706 11.4998 50.5916 11.9225 50.4056 12.3791H50.2788V11.2758C50.2788 10.5824 49.7166 10.0203 49.0233 10.0203C48.3299 10.0203 47.7678 10.5824 47.7678 11.2758V21.2563C47.7678 22.0127 48.381 22.6259 49.1374 22.6259C49.8938 22.6259 50.507 22.0127 50.507 21.2563V15.3466C50.507 14.5519 50.6254 13.9263 50.8621 13.4697C51.0988 12.9963 51.4539 12.6581 51.9274 12.4552C52.4008 12.2353 53.0096 12.1254 53.7536 12.1254C54.9203 12.1254 55.715 12.3791 56.1377 12.8863C56.5605 13.3767 56.7718 14.1799 56.7718 15.2959V21.2563Z" fill="#343C54"></path><path d="M45.4591 7.06468C45.4591 7.94509 44.7454 8.6588 43.865 8.6588C42.9903 8.6588 42.2789 7.95389 42.271 7.07917L42.2703 7.00495C42.2622 6.11872 42.9784 5.396 43.8647 5.396C44.7453 5.396 45.4591 6.10986 45.4591 6.99045V7.06468Z" fill="#343C54"></path><path d="M78.4172 7.06468C78.4172 7.94509 77.7035 8.6588 76.8231 8.6588C75.9483 8.6588 75.237 7.95389 75.229 7.07917L75.2283 7.00495C75.2203 6.11872 75.9365 5.396 76.8227 5.396C77.7033 5.396 78.4172 6.10986 78.4172 6.99045V7.06468Z" fill="#343C54"></path><path d="M7.68535 6.78712C7.3683 6.47008 6.89908 6.33058 6.45522 6.44472C6.01135 6.54617 5.65626 6.8759 5.51677 7.31976L0.063606 24.3006C-0.0885752 24.7699 0.0382425 25.2771 0.38065 25.6195C0.634285 25.8732 0.964011 26 1.30642 26C1.43324 26 1.57274 25.9746 1.69955 25.9366L18.6931 20.4834C19.1243 20.3439 19.454 19.9888 19.5682 19.545C19.6823 19.1011 19.5428 18.6319 19.2258 18.3148L7.68535 6.78712ZM3.32282 22.6901L7.34294 10.1478L15.8651 18.6699L3.32282 22.6901Z" fill="#725CFF"></path><path d="M14.6858 9.60203C14.7745 10.2615 15.3325 10.7434 15.9793 10.7434C16.5481 10.7434 17.128 10.6144 17.6913 10.5405C19.3273 10.3249 20.5701 8.91721 20.5574 7.26858V6.86277C20.5574 6.67254 20.6335 6.50768 20.7603 6.38086C20.8871 6.25404 21.0647 6.17795 21.2422 6.17795H23.3981C24.121 6.17795 24.7044 5.59459 24.7044 4.87173C24.7044 4.14887 24.121 3.56551 23.3981 3.56551H21.2422C20.3672 3.56551 19.5429 3.90792 18.9215 4.52932C18.3001 5.15073 17.9577 5.98773 17.9577 6.86277V7.26858C17.9577 7.61099 17.704 7.90267 17.3616 7.94072L15.8144 8.14363C15.1043 8.2324 14.597 8.89185 14.6858 9.60203Z" fill="#725CFF"></path><path d="M27.4557 11.4287C24.1584 8.90501 20.5948 11.137 19.1618 12.6715C18.6672 13.1914 18.7053 14.0158 19.2252 14.5103C19.7528 15.0115 20.5756 14.9725 21.0641 14.4596C21.1655 14.3455 23.6385 11.7838 25.8705 13.4958C26.4411 13.9397 27.2655 13.8255 27.6966 13.2549C28.1405 12.6842 28.0264 11.8599 27.4557 11.4287Z" fill="#725CFF"></path><path d="M13.1762 6.86327C14.6346 5.74728 16.1057 3.13483 14.1907 0.535071C13.7595 -0.0482907 12.9479 -0.175108 12.3645 0.256072C11.7812 0.687252 11.6544 1.49888 12.0855 2.08225C13.0874 3.43919 11.946 4.51714 11.5783 4.80883C11.0076 5.25269 10.9061 6.06432 11.3373 6.635C11.7835 7.21499 12.6035 7.28527 13.1762 6.86327Z" fill="#725CFF"></path></svg>
					<img src="https://raw.githubusercontent.com/picocss/pico/HEAD/.github/logo-light.svg">
				</div>
				<p><u>Advantages:</u></p>
				<h2>Fast theme deployment</h2>
				<p>Write pure HTML and CSS</p>
				<h2>Examples</h2>
				<p>Functional example code in custom page templates</p>
				<h2>Trusted web components</h2>
				<p>Tried and tested code libraries</p>
				<h2>De-toxtinated code</h2>
				<p>Clean style.css and functions.php</p>
				<h2>WordPress source code that looks like a “normal” website</h2>
				<p>Clear and precise source code indentation control for custom page templates</p>
				<h2>Add code libraries by writing HTML instead of php functions</h2>
				<p>Freely use &#x3C;link rel=&#x22;stylesheet&#x22;&#x3E; in header.php and &#x3C;script src=&#x22;&#x22;&#x3E; in footer.php to add code libraries</p>
				<h2>Adaptable and easy to use</h2>
				<p>Requires only a basic knowledge of HTML and CSS to build</p>
				<h2>Optimised &#x3C;head&#x3E; code
				<p>Eliminates top heavy pages ensuring body content source code is above the page fold</p>
				<h2>Control &#x3C;title&#x3E; tags</h2>
				<p>&#x3C;?php echo $GLOBALS[$__title]; ?&#x3E; for &#x3C;title&#x3E; tag on page templates</p>
				<h2>Improves page load speed</h2>
				<p>Reduce web page resource overhead by restricting default WordPress output code</p>
				<h2>Unique and lightweight</h2>
				<p>Make your WordPress theme unique from the ground up using our theme</p>
				
					
				<div class="zig-zag"></div>
		
					
				<cite>
					<h3>Credit</h3>
					<p><b>Current</b> Fruitty HTML 1st WordPress theme made by <a href="https://www.slibdesign.com">Ben – WordPress developer London</a> AKA “Mr WordPress” WordPress developer since 2006. Ben is the Founder of Slib Design Limited, worked with over <span>200</span> clients since 2006, launching innovative products and services throughout the World. <b>2025</b>, Ben created <a href="https://www.wordpressdeveloperlondon.com">wordpressdeveloperlodon.com – A framework for WordPress plugin modification</a> which enabled web developers to modernise WordPress site functionality with WordPress child plugins. Currently the home of <span>44,591</span> wordpress.org compatible child plugins advancing WordPress development principals for WordPress developers who select not to customise functions.php files in WordPress themes making WordPress feature code updates transportable across multiple WordPress sites easier and faster. <b>2019</b>, Ben launched childthemewp.com now known as <a href="https://www.wordpresschildtheme.com">wordpresschildtheme.com – A framework for WordPress theme modification</a> one of the largest WordPress child theme libraries in the World stocking <span>14,071</span> child themes supporting WordPress developers to create custom website style changes without changing parent themes, futureproofing website integrity. Ben’s platforms have over <span>1 million</span> downloads so far.</p>
				</cite>
			</article>
		</main>
<?php get_footer(); ?>